/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.world;

import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import energon.srpextra.Main;
import energon.srpextra.world.SRPEStructureUtils;
import energon.srpextra.world.WorldGenSpawn;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCenter
implements IWorldGenerator {
    public static List<SRPEStructureUtils> structureList = new ArrayList<SRPEStructureUtils>();
    public static int tierZero = 4;
    public static int tierOne = 8;
    public static int tierTwo = 16;
    public static int globalWeight = 100;
    public static boolean debug = false;
    public static boolean ENABLE = !Main.srpcotesia;

    public void generate(Random random, int i, int i1, World world, IChunkGenerator iChunkGenerator, IChunkProvider iChunkProvider) {
        if (!ENABLE) {
            return;
        }
        int dimId = world.field_73011_w.getDimension();
        byte phase = SRPSaveData.get((World)world).getEvolutionPhase(dimId);
        BlockPos pos = new BlockPos(i * 16 + (random.nextInt(32) - 16), 0, i1 * 16 + (random.nextInt(32) - 16));
        if (i % tierTwo == 0 && i1 % tierTwo == 0 && WorldGenCenter.getTier(random, 2, phase, dimId, world, pos)) {
            return;
        }
        if (i % tierOne == 0 && i1 % tierOne == 0 && WorldGenCenter.getTier(random, 1, phase, dimId, world, pos)) {
            return;
        }
        if (i % tierZero == 0 && i1 % tierZero == 0 && WorldGenCenter.getTier(random, 0, phase, dimId, world, pos)) {
            return;
        }
    }

    private static boolean getTier(Random random, int tier, int phase, int dimId, World world, BlockPos pos) {
        int randNum = random.nextInt(globalWeight);
        int testNum = 0;
        for (SRPEStructureUtils solo : structureList) {
            if (solo.tier != tier || solo.weight <= 0 || !solo.checkWorld(dimId) || randNum >= (testNum += solo.weight)) continue;
            return WorldGenSpawn.spawn(world, pos, solo, random, true, phase) == 1;
        }
        return false;
    }

    @Nullable
    public static SRPEStructureUtils search(String searchName) {
        if (searchName == null) {
            return null;
        }
        for (SRPEStructureUtils element : structureList) {
            if (!element.name.equals(searchName)) continue;
            return element;
        }
        return null;
    }
}

